[//lasso
	/*
	============================================================================
	Simple Web 2.0 with Lasso and jQuery - My Saved Links Module
	============================================================================
	Author: Jason Huck/Core Five Creative
	Lasso Summit 2007
	----------------------------------------------------------------------------
	
	This module displays a list of favorite links. When you enter a URL in the
	box, it does an [include_url] on the server side, parses out the <title>, 
	stores the title and link in a session, and refreshes the list on the page, 
	all via ajax. You can delete links in a similar manner.
	*/


	// start/refresh user session with 'links' var
	session_start( -name='jquerydemo', -expires=(60 * 24 * 365));
	session_addvar('links', -name='jquerydemo');
	
	// if no symbols are stored, use defaults
	!var_defined('links') ? var('links') = array(
		'jQuery' = 'http://www.jquery.com',
		'jQuery Discuss' = 'http://www.nabble.com/JQuery-f15494.html',
		'Visual jQuery' = 'http://www.visualjquery.com',
		'Learning jQuery' = 'http://www.learningjquery.com',
		'tagSwap' = 'http://www.tagSwap.net'
	);
	
	
	// define a tag to generate the html for the links
	define_tag('mysavedlinks', -req='links', -copy);
		#links->sort;
		local('out' = string);
		
		iterate(#links, local('i'));
			local('title') = #i->first;
			#title->size > 30 ? #title = #title->substring(0,25) + '...';
		
			#out += '
						<li id="link' + loop_count + 'row">
							<a id="link' + loop_count + '" class="remlinkbtn" href="#"><img src="lib/images/delete.gif" width="14" height="14" align="top" /></a>
							<a id="link' + loop_count + 'id" title="' + #i->first + '" href="' + #i->second + '" target="_blank">' + #title + '</a>
						</li>
			';
		/iterate;
		
		return(@#out);
	/define_tag;
	
	
	// ajax functions
	if(request_isajax);	
		protect;
			var('resp' = string);
			var('newlink') = action_param('link');
			
			// make sure link begins with http 
			!$newlink->beginswith('http://') && !$newlink->beginswith('https://') ? $newlink = 'http://' + $newlink;
			$newlink->removetrailing('/');

			select(action_param('function'));
				// add a new link
				case('add');
					// make sure it's not a duplicate
					local('dupelink') = false;
					iterate($links, local('i'));
						if(#i->second == $newlink);
							#dupelink = true;
							loop_abort;
						/if;
					/iterate;
	
					// grab the url
					protect;
	                    var('linkData') = string(include_url($newlink, -timeout=30));
	                    handle_error;
	                       var('linkData') = '';	
	                    /handle_error;
					/protect;

					// if it's valid and not a duplicate...
					if(valid_url($newlink) && !#dupelink && $linkData);
						// ...extract the title					
						var('linkTitle') = string_findregexp(
							$linkData,
							-find='<title>(.*?)</title>',
							-ignorecase
						)->get(2);
						
						// insert it into the session variable
						$links->insert($linkTitle = $newlink);
						
						// create a new list of links
						$resp += mysavedlinks($links);	
					/if;
					
				// remove a link
				case('remove');
					iterate($links, local('i'));
						if(#i->second == $newlink);
							$links->remove(loop_count);
							loop_abort;
						/if;
					/iterate;
			/select;

			// output the results and abort
			content_body = @$resp;
			abort;	
	
			handle_error;
				content_body = error_msg;
				error_reset;
			/handle_error;
		/protect;
	/if;
	
	// create the initial display
	var('display') = mysavedlinks($links);
]
<script type="text/javascript">					
$(function(){
	// create a function that will find all links of class "remlinkbtn" within
	// the "userlinks" element and bind a click event to them
	bindDeleteLinks = function(){
		$("#userlinks").find("a.remlinkbtn").click(function(){
			// do a little string manipulation to extract the id from 
			// the current link and deduce the id of the surrounding list item
			var linkid = 'a#' + this.id + 'id';
			
			// grab the href attribute of the current link
			var linkname = $(linkid).get(0).href;
			
			// hide the current list item
			$(('li#' + this.id + 'row')).css({display:'none'});
			
			// submit a GET request back to the module to remove the link
			$.get('./?mode=mysavedlinks&function=remove&link=' + linkname,function(){void(null);});
			
			// prevent the click from following the link
			return false;
		});	
	}

	// bind a function to the submit event of "addlinkform"
	$('#addlinkform').submit(function(){
		// store the value of the "addlink" input and clear its value
		var newLink = $('#addlink').val();
		$('#addlink').val('');
		
		// if there was content in the field...
		if(newLink.length > 0) {
			// ...pass the link value as a parameter back to the module and replace
			// the contents of the "userlinks" list with the response
			$('ul#userlinks').load('./?mode=mysavedlinks&function=add&link=' + newLink, function(){
				// we've added new links, so we have to find them and bind them
				// using the function we defined above
				bindDeleteLinks();
			});
		}
		return false;
	});
	
	// call the bind function on initial page load to handle the first set of links
	bindDeleteLinks();
});
</script>

<h2 class="modtitle grey" id="mysavedlinks">My Saved Links</h2>
<div class="mod lightgrey">
	<ul id="userlinks" class="delete">
[$display]
	</ul>
	<form id="addlinkform" class="add" name="link" method="post" action="">
		<input name="addme" type="image" src="lib/images/add.gif" width="14" height="14" align="absmiddle" />
		<input id="addlink" class="boxGreen" type="text" name="mylinks" />
	</form>
</div>
